close all
clear all
clc

% Values for Unicycle simulation

% Simulation parameters
    tmax    = 300;
    deltaT  = 0.01;
    t = 0:deltaT:tmax;
    
% Initial Conditions (initial location of unicycle)
    
    r = .5;%radius of robot(distance of sensor to center of robot)
    
    ICx_sen    =  2;
    ICy_sen    =  2;

    ICx = 2 - r;
    ICy = 2;
% Nonlinear map values: f(x,y) = max/[1 + qx*(x-x*)^2 + qy*(y-y*)^2]
    max   = 1;
    qx    = 1/2;
    qy    = 1/4;
    centx = 0;
    centy = 0;
    
% ES values: cx,cy := signal gains
    a   =0.04;
    w   =25;   %frequency of ES
    w1 = 5;    %frequency of turning
    c = 50;
    h   = 1;
    v   = 1;
    
    W = 0.03;
    
    sim('ES_Unicycle_nc_tune_V_moving')
    plot(x,y,'k')
    hold on
    %plot(x_sen,y_sen,'b')
    plot(sin(W*t),-sin(2*W*t),'r')
    %legend('center of AUV','sensor position','trajectory of maxima')
    hold off